---
name: Egyptian Mythology Theme "Quest of Ra" - Implementation Plan
overview: ""
todos:
  - id: 0505c43e-5a69-4b6d-91e2-0d4d8e9eeadd
    content: Configure Tailwind with Egyptian color palette (papyrus-dark, ra-gold, nile-turquoise, blood-red, desert-sand, shadow-ink)
    status: pending
  - id: 3500d5c6-d58a-4797-9218-23f9f24c27bd
    content: Add Google Fonts (Cinzel Decorative, Noto Serif/Lora, Orbitron) to layout and configure Tailwind font families
    status: pending
  - id: ee504218-f6fb-466a-81a2-c1f369550d2b
    content: Update app.css with Egyptian theme base styles, gradients, glow effects, and utility classes
    status: pending
  - id: 09b5d50c-0a04-4210-86df-7af2f6a68e83
    content: Redesign main app layout with papyrus-dark background, hieroglyph patterns, and temple structure
    status: pending
  - id: 6a351f03-0a3d-4a2e-84a5-226d69b3d983
    content: Transform navigation into hieroglyph menu sidebar with Egyptian icons and golden hover effects
    status: pending
  - id: ff084c99-232e-4828-957d-5d49ecdf311b
    content: Redesign dashboard as temple interface with three-column layout (menu, parchment scroll, Power of Ra panel)
    status: pending
  - id: 1e3bad07-9242-42da-8fef-e9a0b8a44484
    content: Create quest-card component with scroll/papyrus design, hieroglyph overlays, and gold glow effects
    status: pending
  - id: c51f4638-8daf-4787-871e-9481fbceb379
    content: Update all view files (tasks, categories, shop, inventory, battle) with Egyptian styling and terminology
    status: pending
  - id: 56539fe3-6310-43c4-8242-768f6b6121b2
    content: Redesign shop as Market of the Gods with stone tablet items, cartouche buttons, and hover animations
    status: pending
  - id: 39316b0d-ad09-4988-974a-9599566f5382
    content: Redesign battle arena with ancient ruins background, energy orb health bars, and sun fire attack animations
    status: pending
  - id: a7a7c9c1-28f0-4a80-b333-9d5980fcc307
    content: "Replace all user-facing text: Tasks→Quests, Shop→Market of the Gods, Items→Relics, etc."
    status: pending
  - id: be91108c-d0a8-49c7-ba01-cc22c4f6aafc
    content: "Add Alpine.js animations: quest completion glow, level-up flash, battle effects, victory animations"
    status: pending
  - id: d3b47698-44b0-4bcc-aa0c-62a448e200ac
    content: Create/source hieroglyph pattern image and Egyptian-themed visual assets
    status: pending
  - id: 8f0154f6-2deb-4e6c-8cd7-61f907d47cb5
    content: "Create themed Blade components: quest-card, hieroglyph-pattern, xp-progress-sunray, gold-glow"
    status: pending
  - id: 08aa1594-8fe0-4a7a-8434-cd550e556521
    content: Add blessings meter (streak bonus system) with visual indicator for consecutive daily quests
    status: pending
  - id: 139e1d44-9da3-486e-b356-ba9c53b3cae8
    content: "Update stat names to Egyptian terms: Attack→Strength, Defense→Resilience, Magic→Wisdom, Stamina→Endurance"
    status: pending
---

# Egyptian Mythology Theme "Quest of Ra" - Implementation Plan

## Theme Overview

Transform the entire application into an ancient Egyptian mythology experience with:

- Dark papyrus backgrounds (#1a0e0a)
- Gold accents (#d4af37) representing Ra's divine energy
- Turquoise accents (#0fb9b1) for Nile magic
- Mystical scroll/papyrus UI elements
- Hieroglyph patterns and Egyptian fonts

## Phase 1: Foundation - Colors, Fonts & Base Styles

### Custom Color Palette Setup

- Update `tailwind.config.js` with Egyptian color palette:
- `papyrus-dark` (#1a0e0a)
- `ra-gold` (#d4af37)
- `nile-turquoise` (#0fb9b1)
- `blood-red` (#b33939)
- `desert-sand` (#f5e6b2)
- `shadow-ink` (#100803)

### Custom Fonts Integration

- Add Google Fonts to `app.blade.php`:
- Cinzel Decorative (headings - stone engravings look)
- Noto Serif or Lora (body text)
- Orbitron (numbers/stats - divine-tech fusion)
- Configure Tailwind to use custom font families

### Base CSS Enhancements

- Update `resources/css/app.css`:
- Background gradients (papyrus dark)
- Custom utility classes for Egyptian theme
- Glow effects for gold elements
- Hieroglyph pattern overlays

## Phase 2: Layout & Navigation - Temple Interface

### Main Layout Updates

- Update `resources/views/layouts/app.blade.php`:
- Change background from gray-100 to papyrus-dark
- Add hieroglyph pattern overlay
- Update header styling (golden borders)

### Navigation Menu - Hieroglyph Menu

- Redesign `resources/views/layouts/navigation.blade.php`:
- Left sidebar menu with Egyptian icons/emojis
- Menu items: 🏺 Daily Quests, 🗺️ To-Dos, ⚔️ Battle Arena, 💰 Market of the Gods, 🧿 Profile
- Golden hover effects
- Hieroglyph-style separators

### Dashboard Layout - Temple Structure

- Update `resources/views/dashboard.blade.php`:
- Three-column layout: Left sidebar (menu) → Main content (scroll parchment) → Right sidebar (Power of Ra panel)
- Right sidebar shows: Level, XP progress bar (sun ray shape), Gold amount, Equipped items (floating relics)

## Phase 3: Component Styling - Egyptian Theme

### Task Cards → Quest Scrolls

- Create `resources/views/components/quest-card.blade.php`:
- Scroll/papyrus background with golden border
- Hieroglyph pattern overlay (opacity 10%)
- Cinzel Decorative font for titles
- Gold glow on hover
- Update all task views to use quest terminology

### Category Cards - Egyptian Tablet Style

- Update category cards with stone tablet appearance
- Marble texture background
- Hieroglyph edges
- Glowing stone effect

### Shop Items - Market of the Gods

- Update `resources/views/shop/index.blade.php`:
- Items in glowing stone tablets
- Hover animations with hieroglyphs
- Egyptian item names: "Sword of Horus", "Scarab Amulet", "Ra's Cloak", "Eye of Anubis Shield"
- Cartouche-shaped "Buy" buttons

### Battle Arena - Ancient Ruins

- Update battle views:
- Glowing ancient ruins background
- Egyptian warrior avatars (placeholder images initially)
- Health bars as energy orbs (golden light)
- Sun fire beam attack animation
- Eye of Ra victory animation

### User Profile - Blessings of the Gods

- Update profile view:
- Avatar in circular gold cartouche frame
- Stats: Strength, Wisdom, Endurance, Faith (rename from attack/defense/magic/stamina)
- Inventory grid with relic icons
- Background music placeholder (optional)

## Phase 4: Terminology Updates

### Text Replacement Throughout

- Tasks → Quests
- Categories → Quest Types / Scroll Types
- Shop → Market of the Gods
- Inventory → Blessings / Relics Collection
- Battle → Battle Arena / Arena of Horus
- Level → Level (keep as is) or "Rank of Ra"
- Gold → Gold (keep as is) or "Sacred Gold"
- XP → Divine Energy or "Blessing Points"

### Update Controllers/Views

- Update all view files with new terminology
- Keep backend logic the same (only frontend text changes)

## Phase 5: Animations & Visual Effects

### Alpine.js Animations

- Task completion: Gold glow animation (1s), XP bar fill with glow
- Level up: Flash of sunlight across screen, "Ra has blessed you - Level Up!" overlay
- Battle attacks: Sun fire beam effect
- Victory: Floating Eye of Ra with XP gain

### CSS Animations

- Floating sand particles (parallax effect)
- Torch flicker on side panels
- Hieroglyph subtle animations on hover
- Golden light traveling upward on quest completion

### Loading States

- Eye of Ra as page loader
- Animated hieroglyphs during loading

## Phase 6: Visual Assets

### Pattern Overlays

- Create or source hieroglyph pattern image
- Add to `public/images/hieroglyph-pattern.png`

### Icons & Images

- Egyptian-themed icons for menu items
- Placeholder avatars (Egyptian warrior style)
- Background textures (papyrus, marble, ancient stone)

## Phase 7: Enhanced Features

### Blessings Meter

- Add streak bonus system
- Visual indicator showing consecutive daily quest completions
- Bonus multiplier display

### Enhanced Stats Display

- Rename stats to Egyptian terms:
- Attack → Strength
- Defense → Resilience / Protection
- Magic → Wisdom
- Stamina → Endurance
- Add Faith stat (could be derived from achievements)

### Background Music (Optional)

- Placeholder for ambient Egyptian music loop
- Soft oud music with temple echo
- Toggle on/off button

## Implementation Files to Modify

### Core Layout Files

- `resources/views/layouts/app.blade.php` - Main layout background
- `resources/views/layouts/navigation.blade.php` - Egyptian menu
- `resources/css/app.css` - Base styles
- `tailwind.config.js` - Custom colors and fonts

### View Files (Theme Updates)

- `resources/views/dashboard.blade.php` - Temple layout
- `resources/views/tasks/index.blade.php` - Quest list
- `resources/views/tasks/show.blade.php` - Quest detail scroll
- `resources/views/tasks/create.blade.php` - Quest creation
- `resources/views/categories/index.blade.php` - Scroll types
- `resources/views/shop/index.blade.php` - Market of the Gods
- `resources/views/inventory/index.blade.php` - Blessings collection
- `resources/views/battle/index.blade.php` - Arena selection
- `resources/views/battle/show.blade.php` - Battle interface
- `resources/views/admin/dashboard.blade.php` - Admin temple

### New Components to Create

- `resources/views/components/quest-card.blade.php` - Themed task card
- `resources/views/components/hieroglyph-pattern.blade.php` - Pattern overlay
- `resources/views/components/xp-progress-sunray.blade.php` - Sun ray XP bar
- `resources/views/components/gold-glow.blade.php` - Gold glow effects

### JavaScript Files

- `resources/js/app.js` - Add Alpine.js animations
- Optional: Create `resources/js/egyptian-animations.js` for complex effects

## Key Design Elements

### Color Usage

- Background: `papyrus-dark` (#1a0e0a)
- Primary buttons/accents: `ra-gold` (#d4af37)
- Secondary accents: `nile-turquoise` (#0fb9b1)
- Danger/urgent: `blood-red` (#b33939)
- Text on dark: `desert-sand` (#f5e6b2)
- Shadows: `shadow-ink` (#100803)

### Font Usage

- Headings: Cinzel Decorative
- Body text: Noto Serif or Lora
- Numbers/Stats: Orbitron

### Visual Patterns

- Hieroglyph overlays at 10% opacity
- Golden borders with subtle glow
- Scroll/papyrus textures
- Stone tablet surfaces
- Energy orbs for health bars

## Terminology Mapping

| Original | Egyptian Theme |
|----------|----------------|
| Tasks | Quests |
| Daily Tasks | Daily Quests |
| Complete Task | Complete Quest / Earn Blessing |
| Shop | Market of the Gods |
| Items | Relics / Artifacts |
| Equip | Bless with Relic |
| Battle | Arena of Horus / Battle Arena |
| Enemies | Ancient Foes / Guardians |
| Gold | Sacred Gold |
| XP | Divine Energy / Blessing Points |
| Level Up | Ra's Blessing / Ascension |