# 🎮 Gamified Task Manager (Habitica-style)

A full-featured gamified task management system built with Laravel 12, featuring RPG elements, battle system, shop, achievements, and more!

## Features

✅ **Task Management**
- Create tasks with categories (Daily, Weekly, One-time, Custom)
- Subtasks (checklists)
- Comments and image attachments
- Due dates and reminders
- Task completion tracking

🎮 **Gamification**
- XP (Experience Points) and Gold system
- Leveling up (formula: `level = floor(sqrt(xp / 100))`)
- Achievement badges
- Leaderboard

🛒 **Shop & Inventory**
- Purchase items (weapons, armor, potions, tools)
- Equip items for stat bonuses
- Level requirements for items

⚔️ **Battle System**
- Turn-based combat against AI enemies
- Enemy difficulty scales with player level
- XP and gold rewards
- Item drops (10% chance)

👑 **Admin Panel**
- User management
- Item and enemy CRUD
- Analytics dashboard
- Completion rate tracking

## Tech Stack

- **Backend**: Laravel 12
- **Database**: MySQL
- **Frontend**: Blade templates + TailwindCSS 4
- **Authentication**: Laravel Breeze

## Installation

### Prerequisites

- PHP 8.2 or higher
- Composer
- Node.js and npm
- MySQL (or XAMPP with MySQL)
- Git

### Setup Steps

1. **Clone the repository** (if not already done):
   ```bash
   git clone <repository-url>
   cd inkieaskanger
   ```

2. **Install PHP dependencies**:
   ```bash
   composer install
   ```

3. **Install npm dependencies**:
   ```bash
   npm install
   ```

4. **Configure environment**:
   ```bash
   cp .env.example .env
   php artisan key:generate
   ```

5. **Update `.env` file** with your database credentials:
   ```env
   DB_CONNECTION=mysql
   DB_HOST=127.0.0.1
   DB_PORT=3306
   DB_DATABASE=inkieaskanger
   DB_USERNAME=root
   DB_PASSWORD=
   ```

6. **Create the database**:
   ```sql
   CREATE DATABASE inkieaskanger;
   ```

7. **Run migrations**:
   ```bash
   php artisan migrate
   ```

8. **Seed the database** (items, enemies, achievements):
   ```bash
   php artisan db:seed
   ```

9. **Link storage for images**:
   ```bash
   php artisan storage:link
   ```

10. **Build assets**:
    ```bash
    npm run build
    ```

11. **Start the development server**:
    ```bash
    php artisan serve
    ```

12. **Visit the application**:
    ```
    http://localhost:8000
    ```

## First Admin User

To create your first admin user, you can either:

1. **Through Database** (after registering):
   ```sql
   UPDATE users SET is_admin = 1 WHERE email = 'your-email@example.com';
   ```

2. **Through Tinker**:
   ```bash
   php artisan tinker
   ```
   Then:
   ```php
   $user = \App\Models\User::where('email', 'your-email@example.com')->first();
   $user->is_admin = true;
   $user->save();
   ```

## Scheduled Tasks

The application includes scheduled tasks for automatic task regeneration:

- **Daily tasks**: Regenerated every day at midnight
- **Weekly tasks**: Regenerated every Monday at midnight

Make sure to set up a cron job (or use Laravel's scheduler):

```bash
* * * * * cd /path-to-your-project && php artisan schedule:run >> /dev/null 2>&1
```

Or on Windows, use Task Scheduler to run:
```bash
php artisan schedule:run
```

## Key Features Explained

### Leveling System
- **Formula**: `level = floor(sqrt(total_xp / 100))`
- Completing tasks grants XP based on task points and category type
- Daily tasks give 1.5x XP multiplier
- Weekly tasks give 2x XP multiplier

### Battle System
- **Damage Formula**: `damage = attack - (defense / 2) + random(-5, +5)`
- Enemies scale with player level (±2 levels)
- Winning battles grants XP, gold, and sometimes items

### Shop System
- Items have level requirements
- Users need sufficient gold to purchase
- Equipped items boost user stats (attack, defense, magic, stamina)

### Achievements
- Automatically unlocked based on milestones
- Types: tasks completed, level reached, daily tasks, battles won

## Project Structure

```
app/
├── Console/
│   └── Kernel.php          # Scheduled tasks
├── Http/
│   ├── Controllers/
│   │   ├── Admin/          # Admin panel controllers
│   │   ├── TaskController.php
│   │   ├── CategoryController.php
│   │   ├── ShopController.php
│   │   ├── InventoryController.php
│   │   ├── BattleController.php
│   │   └── DashboardController.php
│   └── Middleware/
│       └── IsAdmin.php
├── Models/                  # All Eloquent models
├── Services/
│   ├── GameService.php      # XP, gold, leveling logic
│   ├── BattleService.php    # Combat system
│   ├── TaskService.php      # Task operations
│   └── AssetService.php     # Image generation
├── Events/                  # TaskCompleted, LevelUp, etc.
└── Listeners/               # Event handlers

database/
├── migrations/              # All database migrations
└── seeders/                 # Data seeders

resources/
└── views/
    ├── dashboard.blade.php
    ├── tasks/
    ├── categories/
    ├── shop/
    ├── inventory/
    ├── battle/
    └── admin/
```

## Default Data

After seeding, you'll have:
- **20+ Items**: Weapons, armor, potions, and tools with various stats
- **12 Enemies**: Scaling from level 1 to 15
- **16 Achievements**: Various milestones to unlock

## API Routes (Future)

API routes are planned but not yet implemented. The controllers are structured to easily add API endpoints later.

## Contributing

This is a complete implementation of a gamified task manager. You can extend it with:
- More item types
- Character classes
- Party/team features
- More achievement types
- Email notifications
- Mobile app (using the same backend)

## License

This project is open-source and available for educational purposes.

## Support

For issues or questions, please check the Laravel documentation or create an issue in the repository.

---

**Happy Task Managing! 🎯✨**
