# 🚀 Quick Setup Guide

## Prerequisites
- PHP 8.2+
- Composer
- Node.js & npm
- MySQL (XAMPP recommended)
- Git

## Installation Steps

### 1. Install Dependencies
```bash
composer install
npm install
```

### 2. Environment Setup
```bash
# Copy environment file
cp .env.example .env

# Generate app key
php artisan key:generate
```

### 3. Database Configuration

Edit `.env` file:
```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=inkieaskanger
DB_USERNAME=root
DB_PASSWORD=
```

Create MySQL database:
```sql
CREATE DATABASE inkieaskanger;
```

### 4. Run Migrations & Seeders
```bash
php artisan migrate
php artisan db:seed
```

### 5. Storage Link (for images)
```bash
php artisan storage:link
```

### 6. Build Assets
```bash
npm run build
```

### 7. Start Development Server
```bash
php artisan serve
```

Visit: `http://localhost:8000`

## Create First Admin User

After registering a user, make them admin:

**Option 1: Using Tinker**
```bash
php artisan tinker
```
```php
$user = \App\Models\User::where('email', 'your-email@example.com')->first();
$user->is_admin = true;
$user->save();
exit
```

**Option 2: Direct SQL**
```sql
UPDATE users SET is_admin = 1 WHERE email = 'your-email@example.com';
```

## Scheduled Tasks Setup

For daily/weekly task regeneration, add to cron:

**Linux/Mac:**
```bash
* * * * * cd /path-to-project && php artisan schedule:run >> /dev/null 2>&1
```

**Windows (Task Scheduler):**
- Create a task that runs: `php artisan schedule:run`
- Set it to run every minute

## Default Data

After seeding, you'll have:
- ✅ 20+ items (weapons, armor, potions, tools)
- ✅ 12 enemies (levels 1-15)
- ✅ 16 achievements
- ✅ Empty categories (users create their own)

## First Steps

1. **Register** a new account
2. **Create a category** (e.g., "Daily Tasks")
3. **Create a task** and complete it to earn XP/gold
4. **Visit the shop** to buy items
5. **Equip items** from inventory
6. **Battle enemies** to earn more rewards
7. **Level up** by completing more tasks!

## Troubleshooting

**Migration errors?**
```bash
php artisan migrate:fresh --seed
```

**Storage link issues?**
```bash
php artisan storage:link --force
```

**Assets not loading?**
```bash
npm run build
# or for development
npm run dev
```

**Can't access admin?**
Make sure you've set `is_admin = 1` for your user account.

## Next Steps

- Customize item stats
- Add more enemies
- Create custom achievements
- Modify XP/gold formulas
- Add email notifications (optional)

---

**Enjoy your gamified task manager! 🎮✨**

