<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;

class InitializeUserStats extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'users:init-stats';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Initialize stats for users who have NULL or 0 values';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $users = User::where(function($query) {
            $query->whereNull('attack')
                  ->orWhere('attack', 0)
                  ->orWhereNull('defense')
                  ->orWhere('defense', 0)
                  ->orWhereNull('stamina')
                  ->orWhere('stamina', 0)
                  ->orWhereNull('max_hp')
                  ->orWhere('max_hp', 0);
        })->get();

        $this->info("Found {$users->count()} users with missing stats.");

        $updated = 0;
        foreach ($users as $user) {
            $updatedFields = [];
            
            if (is_null($user->attack) || $user->attack == 0) {
                $user->attack = 12;
                $updatedFields[] = 'attack';
            }
            
            if (is_null($user->defense) || $user->defense == 0) {
                $user->defense = 5;
                $updatedFields[] = 'defense';
            }
            
            if (is_null($user->stamina) || $user->stamina == 0) {
                $user->stamina = 100;
                $updatedFields[] = 'stamina';
            }
            
            if (is_null($user->max_hp) || $user->max_hp == 0) {
                $user->max_hp = 120;
                $user->current_hp = 120;
                $updatedFields[] = 'max_hp & current_hp';
            }
            
            if (is_null($user->level) || $user->level == 0) {
                $user->level = 1;
                $updatedFields[] = 'level';
            }
            
            if (!empty($updatedFields)) {
                $user->save();
                $updated++;
                $this->info("Updated {$user->name}: " . implode(', ', $updatedFields));
            }
        }

        $this->info("Successfully initialized stats for {$updated} users.");
        return Command::SUCCESS;
    }
}
