<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\ReminderService;

class ProcessReminders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'reminders:process';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process and send all due task reminders';

    /**
     * Execute the console command.
     */
    public function handle(ReminderService $reminderService)
    {
        $this->info('Processing reminders...');
        
        $sentCount = $reminderService->processReminders();
        
        $this->info("Processed {$sentCount} reminders.");
        
        return Command::SUCCESS;
    }
}
