<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use Carbon\Carbon;

class RegenerateHP extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'hp:regenerate';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Regenerate 1 HP for all users every minute';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $users = User::whereColumn('current_hp', '<', 'max_hp')->get();
        
        $regenerated = 0;
        $totalHPRegenerated = 0;
        
        foreach ($users as $user) {
            // Get total stats to get current max_hp
            $gameService = app(\App\Services\GameService::class);
            $totalStats = $gameService->getUserTotalStats($user);
            $maxHP = $totalStats['hp'];
            
            $currentHP = $user->current_hp ?? 0;
            
            // If user is already at max HP, skip
            if ($currentHP >= $maxHP) {
                continue;
            }
            
            // Calculate how many minutes have passed since last regeneration
            $minutesSinceRegen = 0;
            if ($user->last_hp_regen_at) {
                $minutesSinceRegen = now()->diffInMinutes($user->last_hp_regen_at);
            } else {
                // If never regenerated, assume 1 minute has passed
                $minutesSinceRegen = 1;
            }
            
            // Regenerate HP for all minutes passed (1 HP per minute)
            // Cap at max HP
            $hpToRegenerate = min($minutesSinceRegen, $maxHP - $currentHP);
            $newHP = $currentHP + $hpToRegenerate;
            
            if ($newHP > $currentHP) {
                $user->current_hp = $newHP;
                $user->last_hp_regen_at = now();
                $user->save();
                $regenerated++;
                $totalHPRegenerated += $hpToRegenerate;
            }
        }
        
        $this->info("Regenerated {$totalHPRegenerated} HP for {$regenerated} users.");
        return Command::SUCCESS;
    }
}

