<?php

namespace App\Events;

use App\Models\Task;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class TaskCompleted
{
    use Dispatchable, SerializesModels;

    public Task $task;
    public int $xpEarned;
    public int $goldEarned;

    /**
     * Create a new event instance.
     */
    public function __construct(Task $task, int $xpEarned, int $goldEarned)
    {
        $this->task = $task;
        $this->xpEarned = $xpEarned;
        $this->goldEarned = $goldEarned;
    }
}
