<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class Arena3LogsController extends Controller
{
    /**
     * Display Arena 3 combat logs.
     */
    public function index()
    {
        $logFile = storage_path('logs/laravel.log');
        $logs = [];
        
        if (File::exists($logFile)) {
            $logContent = File::get($logFile);
            
            // Extract Arena 3 logs
            $pattern = '/\[(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2})\].*?Arena 3 - (Character|Mob) Stats.*?(\{.*?\})/s';
            preg_match_all($pattern, $logContent, $matches, PREG_SET_ORDER);
            
            foreach ($matches as $match) {
                $timestamp = $match[1];
                $type = $match[2];
                $data = json_decode($match[3], true);
                
                if ($data) {
                    $logs[] = [
                        'timestamp' => $timestamp,
                        'type' => $type,
                        'data' => $data,
                    ];
                }
            }
            
            // Sort by timestamp (newest first)
            usort($logs, function($a, $b) {
                return strtotime($b['timestamp']) - strtotime($a['timestamp']);
            });
            
            // Limit to last 50 entries
            $logs = array_slice($logs, 0, 50);
        }
        
        return view('admin.arena3-logs.index', compact('logs'));
    }
}

