<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Mob;
use App\Services\MobService;
use Illuminate\Http\Request;

class MobController extends Controller
{
    protected MobService $mobService;

    public function __construct(MobService $mobService)
    {
        $this->mobService = $mobService;
    }

    /**
     * List mobs with filters.
     */
    public function index(Request $request)
    {
        $level = $request->input('level');
        $rarity = $request->input('rarity');
        $perPage = $request->input('per_page', 20);

        $query = Mob::query();

        if ($level) {
            $query->where('level', $level);
        }

        if ($rarity) {
            $query->where('rarity', $rarity);
        }

        $mobs = $query->paginate($perPage);

        return response()->json($mobs);
    }

    /**
     * Get specific mob details.
     */
    public function show(string $id)
    {
        $mob = Mob::findOrFail($id);
        return response()->json($mob);
    }

    /**
     * Get recommended mobs for a level.
     */
    public function forLevel(int $level)
    {
        $mobs = $this->mobService->getMobForLevel($level);
        return response()->json($mobs);
    }
}
