<?php

namespace App\Http\Controllers;

use App\Models\UserItem;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class InventoryController extends Controller
{
    /**
     * Display the user's inventory.
     */
    public function index()
    {
        $user = Auth::user();
        
        $userItems = $user->userItems()
            ->with('item')
            ->orderBy('equipped', 'desc')
            ->orderBy('purchased_at', 'desc')
            ->get()
            ->groupBy(function ($userItem) {
                return $userItem->item->type;
            });

        return view('inventory.index', compact('userItems'));
    }

    /**
     * Equip an item.
     */
    public function equip(UserItem $userItem)
    {
        if ($userItem->user_id !== Auth::id()) {
            abort(403);
        }

        // Unequip other items of the same type
        Auth::user()->userItems()
            ->whereHas('item', function($q) use ($userItem) {
                $q->where('type', $userItem->item->type);
            })
            ->where('equipped', true)
            ->update(['equipped' => false]);

        // Equip the selected item
        $userItem->update(['equipped' => true]);

        return redirect()->route('inventory.index')
            ->with('success', "Equipped {$userItem->item->name}!");
    }

    /**
     * Unequip an item.
     */
    public function unequip(UserItem $userItem)
    {
        if ($userItem->user_id !== Auth::id()) {
            abort(403);
        }

        $userItem->update(['equipped' => false]);

        return redirect()->route('inventory.index')
            ->with('success', "Unequipped {$userItem->item->name}.");
    }
}
