<?php

namespace App\Http\Controllers;

use App\Services\VipService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RewardController extends Controller
{
    protected VipService $vipService;

    public function __construct(VipService $vipService)
    {
        $this->vipService = $vipService;
    }

    /**
     * Claim daily VIP rewards.
     */
    public function claimDailyVipRewards()
    {
        $user = Auth::user();

        if (!$this->vipService->isVip($user)) {
            return redirect()->back()
                ->with('error', 'You must be a VIP member to claim daily rewards.');
        }

        $success = $this->vipService->grantDailyVipRewards($user);

        if (!$success) {
            return redirect()->back()
                ->with('error', 'Daily rewards have already been claimed today.');
        }

        $membership = $this->vipService->getActiveMembership($user);

        return redirect()->back()
            ->with('success', "Claimed daily blessing! Received {$membership->daily_gold_bonus} gold and {$membership->daily_premium_coins} premium coins!");
    }
}
