<?php

namespace App\Http\Controllers;

use App\Models\Task;
use App\Models\TaskComment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TaskCommentController extends Controller
{
    /**
     * Store a newly created comment.
     */
    public function store(Request $request, Task $task)
    {
        $this->authorize('view', $task);

        $validated = $request->validate([
            'text' => ['required', 'string', 'max:1000'],
        ]);

        $task->comments()->create([
            'user_id' => Auth::id(),
            'text' => $validated['text'],
        ]);

        return redirect()->back()->with('success', 'Comment added.');
    }

    /**
     * Remove the specified comment.
     */
    public function destroy(Task $task, TaskComment $comment)
    {
        $this->authorize('view', $task);

        if ($comment->task_id !== $task->id) {
            abort(404);
        }

        // Users can only delete their own comments
        if ($comment->user_id !== Auth::id() && !Auth::user()->is_admin) {
            abort(403);
        }

        $comment->delete();

        return redirect()->back()->with('success', 'Comment deleted.');
    }
}
