<?php

namespace App\Http\Controllers;

use App\Models\Task;
use App\Models\TaskImage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class TaskImageController extends Controller
{
    /**
     * Store a newly uploaded image.
     */
    public function store(Request $request, Task $task)
    {
        $this->authorize('update', $task);

        $validated = $request->validate([
            'image' => ['required', 'image', 'max:2048'], // 2MB max
        ]);

        $path = $validated['image']->store('task-images', 'public');
        
        $task->images()->create([
            'path' => $path,
            'original_name' => $validated['image']->getClientOriginalName(),
        ]);

        return redirect()->back()->with('success', 'Image uploaded.');
    }

    /**
     * Remove the specified image.
     */
    public function destroy(Task $task, TaskImage $image)
    {
        $this->authorize('update', $task);

        if ($image->task_id !== $task->id) {
            abort(404);
        }

        // Delete file from storage
        Storage::disk('public')->delete($image->path);

        $image->delete();

        return redirect()->back()->with('success', 'Image deleted.');
    }
}
