<?php

namespace App\Http\Controllers;

use App\Services\PayPalPaymentService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class WebhookController extends Controller
{
    protected PayPalPaymentService $paypalService;

    public function __construct(PayPalPaymentService $paypalService)
    {
        $this->paypalService = $paypalService;
    }

    /**
     * Handle PayPal webhook events.
     */
    public function paypal(Request $request)
    {
        // Get webhook headers and body
        $headers = $request->headers->all();
        $body = $request->getContent();

        // Verify webhook signature
        if (!$this->paypalService->verifyWebhookSignature($headers, $body)) {
            Log::warning('PayPal webhook signature verification failed', [
                'headers' => $headers,
            ]);

            return response()->json(['error' => 'Invalid signature'], 400);
        }

        // Parse webhook event
        $event = $request->all();

        // Handle webhook event
        $this->paypalService->handleWebhookEvent($event);

        return response()->json(['status' => 'ok'], 200);
    }
}
