<?php

namespace App\Listeners;

use App\Events\LevelUp;
use App\Services\GameService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class CheckAchievements
{
    protected GameService $gameService;

    /**
     * Create the event listener.
     */
    public function __construct(GameService $gameService)
    {
        $this->gameService = $gameService;
    }

    /**
     * Handle the event.
     */
    public function handle(LevelUp $event): void
    {
        // Check for level-based achievements
        $this->gameService->checkAchievements($event->user, 'level_reached');
    }
}
