<?php

namespace App\Listeners;

use App\Events\LevelUp;
use App\Models\Character;

class UnlockCharactersOnLevelUp
{
    /**
     * Handle the event.
     */
    public function handle(LevelUp $event): void
    {
        $user = $event->user;
        $newLevel = $event->newLevel;
        
        // Unlock characters for this level
        $charactersToUnlock = Character::where('unlock_level', $newLevel)
            ->where('is_active', true)
            ->whereDoesntHave('users', function($query) use ($user) {
                $query->where('user_id', $user->id);
            })
            ->get();
        
        foreach ($charactersToUnlock as $character) {
            $user->characters()->attach($character->id, [
                'unlocked_at' => now(),
                'unlock_method' => 'level_up',
            ]);
        }
    }
}
