<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Battle extends Model
{
    protected $fillable = [
        'user_id',
        'enemy_id',
        'result',
        'earned_xp',
        'earned_gold',
        'user_hp_remaining',
        'enemy_hp_remaining',
        'turns_taken',
    ];

    protected function casts(): array
    {
        return [
            'earned_xp' => 'integer',
            'earned_gold' => 'integer',
            'user_hp_remaining' => 'integer',
            'enemy_hp_remaining' => 'integer',
            'turns_taken' => 'integer',
        ];
    }

    /**
     * Get the user that fought the battle.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the enemy that was fought.
     */
    public function enemy(): BelongsTo
    {
        return $this->belongsTo(Enemy::class);
    }
}
