<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BattleHistory extends Model
{
    protected $fillable = [
        'user_id',
        'mob_id',
        'result',
        'turns',
        'earned_xp',
        'earned_gold',
        'earned_premium_coins',
        'log',
    ];

    protected function casts(): array
    {
        return [
            'turns' => 'integer',
            'earned_xp' => 'integer',
            'earned_gold' => 'integer',
            'earned_premium_coins' => 'integer',
            'log' => 'array',
        ];
    }

    /**
     * Get the user that fought the battle.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the mob that was fought.
     */
    public function mob(): BelongsTo
    {
        return $this->belongsTo(Mob::class);
    }
}
