<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Builder;

class CoinPack extends Model
{
    protected $fillable = [
        'name',
        'coins_amount',
        'bonus_coins',
        'price_usd',
        'price_egp',
        'is_active',
    ];

    protected function casts(): array
    {
        return [
            'coins_amount' => 'integer',
            'bonus_coins' => 'integer',
            'price_usd' => 'decimal:2',
            'price_egp' => 'decimal:2',
            'is_active' => 'boolean',
        ];
    }

    /**
     * Get the transactions for this coin pack.
     */
    public function transactions(): HasMany
    {
        return $this->hasMany(Transaction::class);
    }

    /**
     * Scope a query to only include active packs.
     */
    public function scopeActive(Builder $query): Builder
    {
        return $query->where('is_active', true);
    }

    /**
     * Get total coins (base + bonus).
     */
    public function getTotalCoinsAttribute(): int
    {
        return $this->coins_amount + $this->bonus_coins;
    }
}
