<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Enemy extends Model
{
    protected $fillable = [
        'name',
        'level',
        'attack',
        'defense',
        'hp',
        'image_url',
        'xp_reward',
        'gold_reward',
        'drop_item_id',
    ];

    protected function casts(): array
    {
        return [
            'level' => 'integer',
            'attack' => 'integer',
            'defense' => 'integer',
            'hp' => 'integer',
            'xp_reward' => 'integer',
            'gold_reward' => 'integer',
        ];
    }

    /**
     * Get the battles for the enemy.
     */
    public function battles(): HasMany
    {
        return $this->hasMany(Battle::class);
    }

    /**
     * Get the drop item.
     */
    public function dropItem(): BelongsTo
    {
        return $this->belongsTo(Item::class, 'drop_item_id');
    }
}
