<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Item extends Model
{
    protected $fillable = [
        'name',
        'type',
        'attack',
        'defense',
        'magic',
        'stamina',
        'cost',
        'image_url',
        'required_level',
        'premium_coins_cost',
        'is_vip_only',
        'is_premium',
    ];

    protected function casts(): array
    {
        return [
            'attack' => 'integer',
            'defense' => 'integer',
            'magic' => 'integer',
            'stamina' => 'integer',
            'cost' => 'integer',
            'required_level' => 'integer',
            'premium_coins_cost' => 'integer',
            'is_vip_only' => 'boolean',
            'is_premium' => 'boolean',
        ];
    }

    /**
     * Get the users that own this item.
     */
    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'user_items')
            ->withPivot('equipped', 'purchased_at')
            ->withTimestamps();
    }

    /**
     * Get the user items.
     */
    public function userItems(): HasMany
    {
        return $this->hasMany(UserItem::class);
    }
}
