<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Level extends Model
{
    protected $fillable = [
        'level',
        'xp_required',
        'hp_bonus',
        'attack_bonus',
        'defense_bonus',
        'stamina_bonus',
        'title',
    ];

    protected function casts(): array
    {
        return [
            'level' => 'integer',
            'xp_required' => 'integer',
            'hp_bonus' => 'integer',
            'attack_bonus' => 'integer',
            'defense_bonus' => 'integer',
            'stamina_bonus' => 'integer',
        ];
    }

    /**
     * Find a level by its level number.
     */
    public static function findByLevel(int $level): ?self
    {
        return static::where('level', $level)->first();
    }

    /**
     * Get users at this level.
     */
    public function users(): HasMany
    {
        return $this->hasMany(User::class, 'level', 'level');
    }
}
