<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Membership extends Model
{
    protected $fillable = [
        'name',
        'monthly_price',
        'yearly_price',
        'xp_bonus_percent',
        'gold_bonus_percent',
        'daily_premium_coins',
        'daily_gold_bonus',
        'vip_special_items_access',
        'vip_event_access',
        'battle_cooldown_reduction',
    ];

    protected function casts(): array
    {
        return [
            'monthly_price' => 'decimal:2',
            'yearly_price' => 'decimal:2',
            'xp_bonus_percent' => 'integer',
            'gold_bonus_percent' => 'integer',
            'daily_premium_coins' => 'integer',
            'daily_gold_bonus' => 'integer',
            'vip_special_items_access' => 'boolean',
            'vip_event_access' => 'boolean',
            'battle_cooldown_reduction' => 'integer',
        ];
    }

    /**
     * Get the users with this membership.
     */
    public function users(): HasMany
    {
        return $this->hasMany(User::class);
    }
}
