<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TaskChecklist extends Model
{
    protected $fillable = [
        'task_id',
        'title',
        'completed',
        'order',
    ];

    protected function casts(): array
    {
        return [
            'completed' => 'boolean',
            'order' => 'integer',
        ];
    }

    /**
     * Get the task that owns the checklist item.
     */
    public function task(): BelongsTo
    {
        return $this->belongsTo(Task::class);
    }
}
