<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Transaction extends Model
{
    const STATUS_PENDING = 'pending';
    const STATUS_COMPLETED = 'completed';
    const STATUS_FAILED = 'failed';
    const STATUS_CANCELLED = 'cancelled';

    const TYPE_VIP = 'vip';
    const TYPE_COINS = 'coins';
    const TYPE_EVENT = 'event';

    protected $fillable = [
        'user_id',
        'type',
        'gateway',
        'amount',
        'currency',
        'status',
        'paypal_order_id',
        'paypal_subscription_id',
        'metadata',
        'membership_id',
        'coin_pack_id',
        'coins_amount',
    ];

    protected function casts(): array
    {
        return [
            'amount' => 'decimal:2',
            'metadata' => 'array',
            'coins_amount' => 'integer',
        ];
    }

    /**
     * Get the user that owns the transaction.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the membership for VIP transactions.
     */
    public function membership(): BelongsTo
    {
        return $this->belongsTo(Membership::class);
    }

    /**
     * Get the coin pack for coin transactions.
     */
    public function coinPack(): BelongsTo
    {
        return $this->belongsTo(CoinPack::class);
    }

    /**
     * Check if transaction is completed.
     */
    public function isCompleted(): bool
    {
        return $this->status === self::STATUS_COMPLETED;
    }

    /**
     * Check if transaction is pending.
     */
    public function isPending(): bool
    {
        return $this->status === self::STATUS_PENDING;
    }
}
