<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserItem extends Model
{
    protected $fillable = [
        'user_id',
        'item_id',
        'equipped',
        'purchased_at',
    ];

    protected function casts(): array
    {
        return [
            'equipped' => 'boolean',
            'purchased_at' => 'datetime',
        ];
    }

    /**
     * Get the user that owns the item.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the item.
     */
    public function item(): BelongsTo
    {
        return $this->belongsTo(Item::class);
    }
}
