<?php

namespace App\Policies;

use App\Models\ScrollCategory;
use App\Models\User;

class ScrollCategoryPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, ScrollCategory $scrollCategory): bool
    {
        return $scrollCategory->user_id === null || $user->id === $scrollCategory->user_id;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, ScrollCategory $scrollCategory): bool
    {
        return $scrollCategory->user_id === null || $user->id === $scrollCategory->user_id;
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, ScrollCategory $scrollCategory): bool
    {
        return $scrollCategory->user_id !== null && $user->id === $scrollCategory->user_id;
    }
}
