<?php

namespace App\Services;

class AssetService
{
    /**
     * Generate a placeholder image URL for characters.
     */
    public function generateCharacterImage(): string
    {
        // Using placeholder images - can be replaced with actual API later
        return 'https://picsum.photos/200/200?random=' . rand(1, 1000);
    }

    /**
     * Generate a placeholder image URL for items.
     */
    public function generateItemImage(): string
    {
        // Using placeholder images
        return 'https://picsum.photos/150/150?random=' . rand(2000, 3000);
    }

    /**
     * Generate a placeholder image URL for enemies.
     */
    public function generateEnemyImage(): string
    {
        // Using placeholder images
        return 'https://picsum.photos/200/200?random=' . rand(3000, 4000);
    }

    /**
     * Get a random placeholder image URL.
     */
    public function getPlaceholderImage(int $width = 200, int $height = 200): string
    {
        return "https://picsum.photos/{$width}/{$height}?random=" . rand(1, 5000);
    }
}

