<?php

namespace App\Services;

use App\Models\User;
use App\Events\PremiumCoinsEarned;
use Illuminate\Support\Facades\Log;

class CurrencyService
{
    protected GameService $gameService;

    public function __construct(GameService $gameService)
    {
        $this->gameService = $gameService;
    }

    /**
     * Add premium coins to a user.
     */
    public function addPremiumCoins(User $user, int $amount): void
    {
        $user->premium_coins += $amount;
        $user->save();

        event(new PremiumCoinsEarned($user, $amount));

        Log::info("Added {$amount} premium coins to user {$user->id}");
    }

    /**
     * Deduct premium coins from a user.
     */
    public function deductPremiumCoins(User $user, int $amount): bool
    {
        if ($user->premium_coins < $amount) {
            return false;
        }

        $user->premium_coins -= $amount;
        $user->save();

        Log::info("Deducted {$amount} premium coins from user {$user->id}");

        return true;
    }

    /**
     * Check if user has enough premium coins.
     */
    public function hasEnoughPremiumCoins(User $user, int $amount): bool
    {
        return $user->premium_coins >= $amount;
    }

    /**
     * Add gold to a user.
     */
    public function addGold(User $user, int $amount): void
    {
        $this->gameService->addGold($user, $amount);
    }

    /**
     * Deduct gold from a user.
     */
    public function deductGold(User $user, int $amount): bool
    {
        return $this->gameService->deductGold($user, $amount);
    }
}

