<?php

namespace App\Services;

use App\Models\Mob;
use Illuminate\Support\Collection;

class MobService
{
    /**
     * Get appropriate mob(s) for player level with scaling.
     */
    public function getMobForLevel(int $level, array $filters = []): Collection
    {
        $query = Mob::query();

        // Level range: ±5 levels from player level
        $minLevel = max(1, $level - 5);
        $maxLevel = min(80, $level + 5);
        
        $query->whereBetween('level', [$minLevel, $maxLevel]);

        // Apply filters
        if (isset($filters['rarity'])) {
            $query->where('rarity', $filters['rarity']);
        }

        if (isset($filters['ai_type'])) {
            $query->where('ai_type', $filters['ai_type']);
        }

        return $query->inRandomOrder()->limit($filters['limit'] ?? 10)->get();
    }

    /**
     * Get specific mob by ID.
     */
    public function getMobById(int $id): ?Mob
    {
        return Mob::find($id);
    }

    /**
     * Get mobs by level range.
     */
    public function getMobsByLevelRange(int $minLevel, int $maxLevel): Collection
    {
        return Mob::whereBetween('level', [$minLevel, $maxLevel])
            ->orderBy('level')
            ->get();
    }

    /**
     * Scale mob stats if needed for difficulty adjustment.
     */
    public function scaleMobStats(Mob $mob, int $playerLevel): Mob
    {
        // For now, return mob as-is
        // Can be extended to scale stats based on player level difference
        return $mob;
    }
}


