<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Character Animation States
    |--------------------------------------------------------------------------
    |
    | Available animation states for characters. Each state maps to a PNG sequence
    | folder in the format: /assets/characters/{slug}/{state}/01.png, 02.png, etc.
    |
    | Special mappings:
    | - 'attack' maps to 'fight' folder
    |
    | Note: PNG sequences are already animated, so we don't need separate _anim variants.
    |
    */

    'states' => [
        'idle',
        'attack',
        'magic',
        'win',
        'lose',
    ],

    /*
    |--------------------------------------------------------------------------
    | Looping States
    |--------------------------------------------------------------------------
    |
    | States that should loop continuously when playing.
    |
    */

    'looping_states' => [
        'idle',
        'magic',
    ],

    /*
    |--------------------------------------------------------------------------
    | Non-Looping States
    |--------------------------------------------------------------------------
    |
    | States that play once and then return to idle.
    |
    */

    'non_looping_states' => [
        'attack',
        'lose',
    ],

    /*
    |--------------------------------------------------------------------------
    | Auto-Return States
    |--------------------------------------------------------------------------
    |
    | States that automatically return to idle when the animation ends.
    |
    */

    'auto_return_states' => [
        'attack',
        'lose',
        'magic',
    ],

    /*
    |--------------------------------------------------------------------------
    | Stay on Last Frame States
    |--------------------------------------------------------------------------
    |
    | States that should stay on the last frame when the animation ends.
    |
    */

    'stay_on_last_frame_states' => [
        'win',
    ],

    /*
    |--------------------------------------------------------------------------
    | Default State
    |--------------------------------------------------------------------------
    |
    | The default state to use when a requested state is not available.
    |
    */

    'default_state' => 'idle',
];

