<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Task Difficulty Levels Configuration
    |--------------------------------------------------------------------------
    |
    | This configuration defines the points and coins for each difficulty level.
    | When a task is created with a difficulty level, these values will be
    | automatically assigned.
    |
    */

    'levels' => [
        'easy' => [
            'points' => 10,
            'coins' => 5,
            'label' => 'Easy',
            'description' => 'Simple quests for beginners',
        ],
        'medium' => [
            'points' => 25,
            'coins' => 15,
            'label' => 'Medium',
            'description' => 'Moderate challenges',
        ],
        'hard' => [
            'points' => 50,
            'coins' => 35,
            'label' => 'Hard',
            'description' => 'Difficult quests for experienced adventurers',
        ],
        'expert' => [
            'points' => 100,
            'coins' => 75,
            'label' => 'Expert',
            'description' => 'The most challenging quests',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Default Difficulty Level
    |--------------------------------------------------------------------------
    |
    | The default difficulty level when creating a new task.
    |
    */
    'default' => 'medium',
];

