<?php

return [
    /*
    |--------------------------------------------------------------------------
    | PayPal Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration for PayPal payment integration
    |
    */

    'mode' => env('PAYPAL_MODE', 'sandbox'), // 'sandbox' or 'live'

    'client_id' => env('PAYPAL_CLIENT_ID'),
    'client_secret' => env('PAYPAL_CLIENT_SECRET'),

    'currency' => env('PAYPAL_CURRENCY', 'USD'),

    /*
    |--------------------------------------------------------------------------
    | PayPal URLs
    |--------------------------------------------------------------------------
    */

    'return_url' => env('APP_URL') . '/vip/success',
    'cancel_url' => env('APP_URL') . '/vip/cancel',

    'coins_return_url' => env('APP_URL') . '/coins/success',
    'coins_cancel_url' => env('APP_URL') . '/coins/cancel',

    'webhook_url' => env('APP_URL') . '/webhook/paypal',

    /*
    |--------------------------------------------------------------------------
    | PayPal API Endpoints
    |--------------------------------------------------------------------------
    */

    'sandbox_api_url' => 'https://api.sandbox.paypal.com',
    'live_api_url' => 'https://api.paypal.com',

    'api_url' => env('PAYPAL_MODE', 'sandbox') === 'sandbox'
        ? 'https://api.sandbox.paypal.com'
        : 'https://api.paypal.com',
];

