<?php

namespace Database\Factories;

use App\Models\Mob;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Mob>
 */
class MobFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $name = fake()->words(2, true);
        
        return [
            'name' => $name,
            'slug' => Str::slug($name),
            'level' => fake()->numberBetween(1, 80),
            'hp' => fake()->numberBetween(50, 500),
            'attack' => fake()->numberBetween(5, 50),
            'defense' => fake()->numberBetween(2, 40),
            'speed' => fake()->numberBetween(5, 30),
            'luck' => fake()->numberBetween(0, 20),
            'xp_reward' => fake()->numberBetween(10, 500),
            'gold_reward' => fake()->numberBetween(5, 200),
            'premium_coin_chance' => fake()->randomFloat(4, 0.005, 0.05),
            'rarity' => fake()->randomElement(['common', 'rare', 'epic', 'legendary']),
            'loot_table' => json_encode([
                'common_drop' => ['chance' => 0.15, 'item_id' => null],
                'rare_drop' => ['chance' => 0.10, 'item_id' => null],
            ]),
            'ai_type' => fake()->randomElement(['passive', 'aggressive', 'strategic']),
            'sprite_source' => '/assets/sprites/mobs/' . Str::slug($name) . '.png',
        ];
    }
}
