<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('characters', function (Blueprint $table) {
            if (!Schema::hasColumn('characters', 'base_hp')) {
                $table->integer('base_hp')->nullable()->after('defense_bonus')->comment('Base HP for Arena 3 (overrides default 200)');
            }
            if (!Schema::hasColumn('characters', 'base_attack')) {
                $table->integer('base_attack')->nullable()->after('base_hp')->comment('Base Attack for Arena 3 (overrides default 50)');
            }
            if (!Schema::hasColumn('characters', 'base_defense')) {
                $table->integer('base_defense')->nullable()->after('base_attack')->comment('Base Defense for Arena 3 (overrides default 20)');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('characters', function (Blueprint $table) {
            if (Schema::hasColumn('characters', 'base_defense')) {
                $table->dropColumn('base_defense');
            }
            if (Schema::hasColumn('characters', 'base_attack')) {
                $table->dropColumn('base_attack');
            }
            if (Schema::hasColumn('characters', 'base_hp')) {
                $table->dropColumn('base_hp');
            }
        });
    }
};

