<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('arena3_backgrounds', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->text('description')->nullable();
            $table->string('image_path'); // Path to background image
            $table->string('shop_image_path')->nullable(); // Optional shop animation image
            $table->integer('cost_gold')->nullable()->comment('Gold cost (null = free)');
            $table->integer('cost_premium')->nullable()->comment('Premium coins cost (null = not purchasable)');
            $table->integer('unlock_level')->nullable()->comment('Level required to unlock (null = shop only)');
            $table->boolean('is_vip_only')->default(false);
            $table->boolean('is_default')->default(false)->comment('Default background for new users');
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);
            $table->timestamps();
        });
        
        // Create user_arena3_backgrounds pivot table for owned backgrounds
        Schema::create('user_arena3_backgrounds', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('arena3_background_id')->constrained('arena3_backgrounds')->onDelete('cascade');
            $table->boolean('is_selected')->default(false)->comment('Currently selected background');
            $table->timestamp('unlocked_at')->nullable();
            $table->string('unlock_method')->nullable()->comment('purchase_gold, purchase_premium, level_up, default');
            $table->timestamps();
            
            $table->unique(['user_id', 'arena3_background_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_arena3_backgrounds');
        Schema::dropIfExists('arena3_backgrounds');
    }
};

