<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('items', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->enum('type', ['weapon', 'armor', 'potion', 'tool']);
            $table->integer('attack')->default(0);
            $table->integer('defense')->default(0);
            $table->integer('magic')->default(0);
            $table->integer('stamina')->default(0);
            $table->integer('cost');
            $table->string('image_url')->nullable();
            $table->integer('required_level')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('items');
    }
};
