<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('battles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('enemy_id')->constrained()->onDelete('cascade');
            $table->enum('result', ['win', 'lose'])->nullable();
            $table->integer('earned_xp')->default(0);
            $table->integer('earned_gold')->default(0);
            $table->integer('user_hp_remaining')->default(0);
            $table->integer('enemy_hp_remaining')->default(0);
            $table->integer('turns_taken')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('battles');
    }
};
