<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update existing 'once' values to 'one-time'
        DB::table('categories')
            ->where('repeat_type', 'once')
            ->update(['repeat_type' => 'one-time']);
        
        DB::table('categories')
            ->where('repeat_type', 'custom')
            ->update(['repeat_type' => 'one-time']);
        
        // Modify the enum column to include new values
        DB::statement("ALTER TABLE categories MODIFY COLUMN repeat_type ENUM('one-time', 'daily', 'weekly', 'monthly', 'yearly') DEFAULT 'one-time'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Convert back to old values
        DB::table('categories')
            ->where('repeat_type', 'one-time')
            ->update(['repeat_type' => 'once']);
        
        DB::table('categories')
            ->whereIn('repeat_type', ['monthly', 'yearly'])
            ->update(['repeat_type' => 'once']);
        
        // Restore old enum
        DB::statement("ALTER TABLE categories MODIFY COLUMN repeat_type ENUM('daily', 'weekly', 'once', 'custom') DEFAULT 'once'");
    }
};
