<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->boolean('is_vip')->default(false)->after('is_admin');
            $table->timestamp('vip_expires_at')->nullable()->after('is_vip');
            $table->integer('premium_coins')->default(0)->after('vip_expires_at');
            $table->unsignedBigInteger('membership_id')->nullable()->after('premium_coins');
            $table->timestamp('last_vip_reward_claimed_at')->nullable()->after('membership_id');
            $table->timestamp('last_battle_at')->nullable()->after('last_vip_reward_claimed_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['membership_id']);
            $table->dropColumn([
                'is_vip',
                'vip_expires_at',
                'premium_coins',
                'membership_id',
                'last_vip_reward_claimed_at',
                'last_battle_at',
            ]);
        });
    }
};
