<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('memberships', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->decimal('monthly_price', 10, 2)->nullable();
            $table->decimal('yearly_price', 10, 2)->nullable();
            $table->integer('xp_bonus_percent')->default(0);
            $table->integer('gold_bonus_percent')->default(0);
            $table->integer('daily_premium_coins')->default(0);
            $table->integer('daily_gold_bonus')->default(0);
            $table->boolean('vip_special_items_access')->default(false);
            $table->boolean('vip_event_access')->default(false);
            $table->integer('battle_cooldown_reduction')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('memberships');
    }
};
