<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('items', function (Blueprint $table) {
            $table->integer('premium_coins_cost')->nullable()->after('cost');
            $table->boolean('is_vip_only')->default(false)->after('premium_coins_cost');
            $table->boolean('is_premium')->default(false)->after('is_vip_only');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('items', function (Blueprint $table) {
            $table->dropColumn([
                'premium_coins_cost',
                'is_vip_only',
                'is_premium',
            ]);
        });
    }
};
