<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->enum('type', ['vip', 'coins', 'event'])->default('vip');
            $table->string('gateway')->default('paypal');
            $table->decimal('amount', 10, 2);
            $table->string('currency', 3)->default('USD');
            $table->enum('status', ['pending', 'completed', 'failed', 'cancelled'])->default('pending');
            $table->string('paypal_order_id')->nullable();
            $table->string('paypal_subscription_id')->nullable();
            $table->json('metadata')->nullable();
            $table->foreignId('membership_id')->nullable()->constrained()->onDelete('set null');
            $table->unsignedBigInteger('coin_pack_id')->nullable();
            $table->integer('coins_amount')->nullable();
            $table->timestamps();

            $table->index('user_id');
            $table->index('status');
            $table->index('paypal_order_id');
            $table->index('paypal_subscription_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
