<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coin_packs', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->integer('coins_amount');
            $table->integer('bonus_coins')->default(0);
            $table->decimal('price_usd', 10, 2);
            $table->decimal('price_egp', 10, 2)->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coin_packs');
    }
};
