<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Add columns only if they don't exist
            $columns = [];
            
            if (!Schema::hasColumn('users', 'level')) {
                $columns[] = 'level';
            }
            if (!Schema::hasColumn('users', 'xp')) {
                $columns[] = 'xp';
            }
            if (!Schema::hasColumn('users', 'max_hp')) {
                $columns[] = 'max_hp';
            }
            if (!Schema::hasColumn('users', 'current_hp')) {
                $columns[] = 'current_hp';
            }
            if (!Schema::hasColumn('users', 'attack')) {
                $columns[] = 'attack';
            }
            if (!Schema::hasColumn('users', 'defense')) {
                $columns[] = 'defense';
            }
            if (!Schema::hasColumn('users', 'stamina')) {
                $columns[] = 'stamina';
            }
            if (!Schema::hasColumn('users', 'luck')) {
                $columns[] = 'luck';
            }
            
            // Add columns in order
            if (in_array('level', $columns)) {
                $table->integer('level')->default(1)->after('id');
            }
            if (in_array('xp', $columns)) {
                $table->unsignedBigInteger('xp')->default(0)->after('level');
            }
            if (in_array('max_hp', $columns)) {
                $table->integer('max_hp')->default(120)->after('xp'); // Higher than first mob (74)
            }
            if (in_array('current_hp', $columns)) {
                $table->integer('current_hp')->default(120)->after('max_hp');
            }
            if (in_array('attack', $columns)) {
                $table->integer('attack')->default(12)->after('current_hp'); // Higher than first mob (7)
            }
            if (in_array('defense', $columns)) {
                $table->integer('defense')->default(5)->after('attack'); // Higher than first mob (2)
            }
            if (in_array('stamina', $columns)) {
                $table->integer('stamina')->default(100)->after('defense');
            }
            if (in_array('luck', $columns)) {
                $table->integer('luck')->default(3)->after('stamina'); // Slightly higher for better crit chance
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $columns = ['level', 'xp', 'max_hp', 'current_hp', 'attack', 'defense', 'stamina', 'luck'];
            foreach ($columns as $column) {
                if (Schema::hasColumn('users', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
