<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mobs', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->integer('level')->indexed();
            $table->integer('hp');
            $table->integer('attack');
            $table->integer('defense');
            $table->integer('speed');
            $table->integer('luck');
            $table->integer('xp_reward');
            $table->integer('gold_reward');
            $table->decimal('premium_coin_chance', 5, 4)->default(0);
            $table->enum('rarity', ['common', 'rare', 'epic', 'legendary'])->default('common')->indexed();
            $table->json('loot_table')->nullable();
            $table->enum('ai_type', ['passive', 'aggressive', 'strategic'])->default('aggressive');
            $table->string('sprite_source')->nullable();
            $table->timestamps();

            $table->index('level');
            $table->index('rarity');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mobs');
    }
};
