<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('shop_items', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->enum('type', ['weapon', 'armor', 'relic', 'potion', 'skin']);
            $table->enum('rarity', ['common', 'rare', 'epic', 'legendary'])->default('common');
            $table->integer('attack_bonus')->default(0);
            $table->integer('defense_bonus')->default(0);
            $table->integer('hp_bonus')->default(0);
            $table->integer('xp_bonus_percent')->default(0);
            $table->integer('gold_bonus_percent')->default(0);
            $table->integer('cost_gold')->default(0);
            $table->integer('cost_premium')->default(0);
            $table->boolean('is_vip_only')->default(false);
            $table->string('image_url')->nullable();
            $table->timestamps();

            $table->index('type');
            $table->index('rarity');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shop_items');
    }
};
