<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('battle_histories', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('mob_id')->constrained()->onDelete('cascade');
            $table->enum('result', ['win', 'lose']);
            $table->integer('turns');
            $table->unsignedBigInteger('earned_xp')->default(0);
            $table->integer('earned_gold')->default(0);
            $table->integer('earned_premium_coins')->default(0);
            $table->json('log')->nullable();
            $table->timestamps();

            $table->index('user_id');
            $table->index('mob_id');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('battle_histories');
    }
};
