<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('character_image_normal')->nullable()->after('avatar_url');
            $table->string('character_image_win')->nullable()->after('character_image_normal');
            $table->string('character_image_loss')->nullable()->after('character_image_win');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['character_image_normal', 'character_image_win', 'character_image_loss']);
        });
    }
};
