<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('task_reminders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('task_id')->constrained()->onDelete('cascade');
            $table->enum('reminder_type', ['green', 'yellow', 'red'])->default('green');
            $table->enum('schedule_type', ['weekly', 'daily', 'custom'])->default('daily');
            $table->json('schedule_data')->nullable(); // For weekly: days of week, for daily: days before due date
            $table->time('reminder_time')->default('09:00:00');
            $table->integer('days_before')->nullable(); // For one-time tasks: days before due date
            $table->timestamp('last_sent_at')->nullable();
            $table->integer('sent_count')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('task_reminders');
    }
};
